#include <iostream>
#include <vector>

#include "fpp.hpp"

bool is_even(int v) {
    return v % 2 == 0;
}

int main() {
    // constructor
    std::cout << "constructor{5, 6, 7, 8}" << std::endl;
    fpp::container<std::vector<int>> vec{5, 6, 7, 8};
    for (auto& i : vec) {
        std::cout << i << ' ';
    }
    std::cout << std::endl;

    // concat
    std::cout << ".concat({5}, {10})" << std::endl;
    auto T = vec.concat(std::vector<int>{ 5 }, std::vector<int>{ 10 });
    for (auto& i : T) {
        std::cout << i << ' ';
    }
    std::cout << std::endl;

    // every
    std::cout << ".every(is_even)" << std::endl
        << T.every(is_even) << std::endl;

    // filter
    std::cout << ".filter(is_even)" << std::endl;
    for (auto& i : T.filter(is_even)) {
        std::cout << i << ' ';
    }
    std::cout << std::endl;

    // find
    std::cout << ".find(is_even)" << std::endl
        << *T.find(is_even) << std::endl;

    // find_index
    std::cout << ".find_index(is_even)" << std::endl
        << T.find_index(is_even) << std::endl;

    // includes
    std::cout << ".includes(2)" << std::endl
        << T.includes(2) << std::endl;

    // index_of
    std::cout << ".index_of(2)" << std::endl
        << T.index_of(2) << std::endl;

    // last_index_of
    std::cout << ".last_index_of(5)" << std::endl
        << T.last_index_of(5) << std::endl;

    // map
    std::cout << ".map(x -> double{x/2})" << std::endl;
    auto T2 = T.map<std::vector<double>>([](int x) {
        return static_cast<double>(x) / 3.0;
    });
    for (auto& i : T2) {
        std::cout << i << ' ';
    }
    std::cout << std::endl;

    std::cout << ".filter(is_even).map(x -> x * x)" << std::endl;
    auto T3 = T.filter(is_even).map([](int x) { return x * x; });
    for (auto& i : T3) {
        std::cout << i << ' ';
    }
    std::cout << std::endl;

    // reduce
    std::cout << ".reduce(acc -> acc + x)" << std::endl
        << T.reduce<int>([](int acc, int x) { return acc + x; }) << std::endl;

    std::cin.get();
    return 0;
}
